/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnparsedDocument;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;

public class DocWriter {
    private JsonFactory jsonFactory;
    private int maxDepth = 100;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
    private boolean pretty;
    private Function<Object, Object> valueMapper;

    public static DocWriter format(Format format) {
        return new DocWriter(format.getJsonFactory());
    }

    public static DocWriter json() {
        return DocWriter.format(Format.JSON);
    }

    public static DocWriter yaml() {
        return DocWriter.format(Format.YAML);
    }

    public static DocWriter smile() {
        return DocWriter.format(Format.SMILE);
    }

    public DocWriter(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public DocWriter pretty() {
        this.pretty = true;
        return this;
    }

    public DocWriter pretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public DocWriter mapValues(Function<Object, Object> valueMapper) {
        this.valueMapper = valueMapper;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String writeAsString(Object object) {
        try (StringWriter writer = new StringWriter();){
            String string;
            block14: {
                JsonGenerator generator = this.jsonFactory.createGenerator((Writer)writer);
                try {
                    if (this.pretty) {
                        generator.useDefaultPrettyPrinter();
                    }
                    this.write(generator, object);
                    generator.flush();
                    writer.flush();
                    string = writer.toString();
                    if (generator == null) break block14;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] writeAsBytes(Object object) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            block14: {
                JsonGenerator generator = this.jsonFactory.createGenerator((OutputStream)out);
                try {
                    if (this.pretty) {
                        generator.useDefaultPrettyPrinter();
                    }
                    this.write(generator, object);
                    generator.flush();
                    out.flush();
                    byArray = out.toByteArray();
                    if (generator == null) break block14;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(File file, Object object) throws IOException {
        try (FileWriter writer = new FileWriter(file);
             JsonGenerator generator = this.jsonFactory.createGenerator((Writer)writer);){
            if (this.pretty) {
                generator.useDefaultPrettyPrinter();
            }
            this.write(generator, object);
            generator.flush();
            writer.flush();
        }
    }

    public String writeAsString(Document<?> document) {
        return this.writeAsString(document != null ? document.toBasicObject() : null);
    }

    public byte[] writeAsBytes(Document<?> document) {
        return this.writeAsBytes(document != null ? document.toBasicObject() : null);
    }

    public void write(File file, Document<?> document) throws IOException {
        this.write(file, document.toBasicObject());
    }

    private void write(JsonGenerator generator, Object object) throws IOException {
        this.write(generator, object, 0);
    }

    private void write(JsonGenerator generator, Object object, int depth) throws IOException {
        if (depth > this.maxDepth) {
            throw new JsonGenerationException("Max JSON depth exceeded", generator);
        }
        if (this.valueMapper != null) {
            object = this.valueMapper.apply(object);
        }
        if (object instanceof Document && !(object instanceof UnparsedDocument)) {
            object = ((Document)object).toBasicObject();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            generator.writeStartArray();
            for (Object element : collection) {
                this.write(generator, element, depth + 1);
            }
            generator.writeEndArray();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            generator.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                generator.writeFieldName(String.valueOf(entry.getKey()));
                this.write(generator, entry.getValue(), depth + 1);
            }
            generator.writeEndObject();
        } else if (object instanceof String) {
            generator.writeString((String)object);
        } else if (object instanceof Character) {
            generator.writeString(object.toString());
        } else if (object instanceof Integer) {
            generator.writeNumber(((Integer)object).intValue());
        } else if (object instanceof Long) {
            generator.writeNumber(((Long)object).longValue());
        } else if (object instanceof Short) {
            generator.writeNumber(((Short)object).shortValue());
        } else if (object instanceof Float) {
            generator.writeNumber(((Float)object).floatValue());
        } else if (object instanceof Double) {
            generator.writeNumber(((Double)object).doubleValue());
        } else if (object instanceof BigDecimal) {
            generator.writeNumber((BigDecimal)object);
        } else if (object instanceof BigInteger) {
            generator.writeNumber((BigInteger)object);
        } else if (object instanceof Number) {
            generator.writeNumber(object.toString());
        } else if (object instanceof Boolean) {
            generator.writeBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof Enum) {
            generator.writeString(((Enum)object).name());
        } else if (object instanceof Date) {
            generator.writeString(this.dateTimeFormatter.format(((Date)object).toInstant()));
        } else if (object instanceof TemporalAccessor) {
            generator.writeString(this.dateTimeFormatter.format((TemporalAccessor)object));
        } else if (object instanceof UnparsedDocument) {
            this.copy(((UnparsedDocument)object).createParser(), generator);
        } else if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            generator.writeStartArray();
            for (int i = 0; i < array.length; ++i) {
                this.write(generator, array[i], depth + 1);
            }
            generator.writeEndArray();
        } else if (object == null) {
            generator.writeNull();
        } else {
            throw new JsonGenerationException("Unsupported object type: " + object.getClass(), generator);
        }
    }

    private void copy(JsonParser parser, JsonGenerator generator) throws IOException {
        JsonToken token;
        JsonToken jsonToken = token = parser.currentToken() != null ? parser.currentToken() : parser.nextToken();
        while (token != null) {
            switch (token) {
                case START_OBJECT: {
                    generator.writeStartObject();
                    break;
                }
                case START_ARRAY: {
                    generator.writeStartArray();
                    break;
                }
                case END_OBJECT: {
                    generator.writeEndObject();
                    break;
                }
                case END_ARRAY: {
                    generator.writeEndArray();
                    break;
                }
                case FIELD_NAME: {
                    generator.writeFieldName(parser.currentName());
                    break;
                }
                case VALUE_TRUE: {
                    generator.writeBoolean(Boolean.TRUE.booleanValue());
                    break;
                }
                case VALUE_FALSE: {
                    generator.writeBoolean(Boolean.FALSE.booleanValue());
                    break;
                }
                case VALUE_NULL: {
                    generator.writeNull();
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    generator.writeNumber(parser.getFloatValue());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    generator.writeNumber(parser.getIntValue());
                    break;
                }
                case VALUE_STRING: {
                    generator.writeString(parser.getText());
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    generator.writeEmbeddedObject(parser.getEmbeddedObject());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected token: " + token);
                }
            }
            token = parser.nextToken();
        }
    }
}

